package pt.caf_pbs.schooldiskclient.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import pt.caf_pbs.schooldiskclient.R;
import pt.caf_pbs.schooldiskclient.model.Instructor;

import java.util.List;

public class ListViewAdapterInstructor extends BaseAdapter {
    private Context context;
    private final List<Instructor> items;

    public ListViewAdapterInstructor(Context context, List<Instructor> instructorsList ) {
        this.context = context;
        this.items = instructorsList;
    }

    @Override
    public int getCount() {
        return this.items.size();
    }

    @Override
    public Object getItem(int position) {
        return this.items.get(position);
    }

    public String getName(int position){
        return this.items.get(position).getName();
    }

    public String getInitials(int position){
        return this.items.get(position).getInitials();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View itemView = null;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            itemView = inflater.inflate(R.layout.list_item, null);
        } else {
            itemView = convertView;
        }

        TextView tv = (TextView) itemView.findViewById(R.id.textview_line);

        tv.setText(getName(position));

        return itemView;
    }
}
